<?php
/**
 * cPanel Cron Setup Verification Script
 * 
 * Upload this file to test your cron job setup
 * Visit: http://core.galliumhash.com/automation/cron-verification.php
 */

// Set timezone
date_default_timezone_set('UTC');

?>
<!DOCTYPE html>
<html>
<head>
    <title>GalliumHash Cron Setup Verification</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; background: #1a1a1a; color: #fff; }
        .success { color: #28a745; font-weight: bold; }
        .error { color: #dc3545; font-weight: bold; }
        .warning { color: #ffc107; font-weight: bold; }
        .info { color: #17a2b8; font-weight: bold; }
        .code { background: #2d2d2d; padding: 10px; border-radius: 4px; font-family: monospace; margin: 10px 0; }
        .section { margin: 20px 0; padding: 15px; border: 1px solid #333; border-radius: 8px; }
    </style>
</head>
<body>
    <h1>🚀 GalliumHash Cron Setup Verification</h1>
    <p>Testing your cPanel automation setup...</p>

    <?php
    $checks = [];
    
    // Check 1: PHP Version
    echo "<div class='section'>";
    echo "<h2>1. PHP Configuration</h2>";
    $phpVersion = phpversion();
    echo "<p>Current PHP Version: <span class='info'>$phpVersion</span></p>";
    
    if (version_compare($phpVersion, '8.0', '>=')) {
        echo "<p class='success'>✅ PHP Version $phpVersion is compatible</p>";
        $checks['php_version'] = true;
    } else {
        echo "<p class='error'>❌ PHP Version $phpVersion is too old (need 8.0+)</p>";
        $checks['php_version'] = false;
    }
    echo "</div>";

    // Check 2: File Permissions
    echo "<div class='section'>";
    echo "<h2>2. File Permissions</h2>";
    $files = [
        'master-scheduler.php',
        'metabuilder-collector.php',
        'metaminer-processor.php',
        'ethereum-gas-collector.php'
    ];
    
    $permissions_ok = true;
    foreach ($files as $file) {
        if (file_exists($file)) {
            $perms = fileperms($file);
            $perms_octal = substr(sprintf('%o', $perms), -4);
            if ($perms_octal >= '644') {
                echo "<p class='success'>✅ $file - permissions: $perms_octal</p>";
            } else {
                echo "<p class='warning'>⚠️ $file - permissions: $perms_octal (recommend 644)</p>";
                $permissions_ok = false;
            }
        } else {
            echo "<p class='error'>❌ $file - file not found</p>";
            $permissions_ok = false;
        }
    }
    $checks['permissions'] = $permissions_ok;
    echo "</div>";

    // Check 3: Environment File
    echo "<div class='section'>";
    echo "<h2>3. Environment Configuration</h2>";
    $envPaths = [
        dirname(dirname(__FILE__)) . '/.env',
        dirname(dirname(__FILE__)) . '/public_html/.env',
        '.env'
    ];
    
    $env_found = false;
    foreach ($envPaths as $envPath) {
        if (file_exists($envPath)) {
            echo "<p class='success'>✅ Found .env file at: $envPath</p>";
            $envData = parse_ini_file($envPath);
            echo "<p>Environment variables loaded: " . count($envData) . " variables</p>";
            $env_found = true;
            break;
        }
    }
    
    if (!$env_found) {
        echo "<p class='error'>❌ .env file not found in any standard location</p>";
        echo "<p class='info'>Expected locations:</p>";
        foreach ($envPaths as $path) {
            echo "<div class='code'>$path</div>";
        }
    }
    $checks['env_file'] = $env_found;
    echo "</div>";

    // Check 4: Database Connection
    echo "<div class='section'>";
    echo "<h2>4. Database Connection</h2>";
    try {
        $dbHost = $_ENV['DB_HOST'] ?? 'localhost';
        $dbName = $_ENV['DB_NAME'] ?? 'metachain';
        $dbUser = $_ENV['DB_USERNAME'] ?? 'nvdaxcom_galliumhash_metabuilder_user';
        $dbPass = $_ENV['DB_PASSWORD'] ?? '32TbgulnE7YOd2G0e5';
        
        $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName", $dbUser, $dbPass);
        echo "<p class='success'>✅ Database connection successful</p>";
        $checks['database'] = true;
        
        // Test table access
        $stmt = $pdo->query("SHOW TABLES");
        $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
        echo "<p>Accessible tables: " . implode(', ', array_slice($tables, 0, 5)) . "...</p>";
        
    } catch (Exception $e) {
        echo "<p class='error'>❌ Database connection failed: " . $e->getMessage() . "</p>";
        $checks['database'] = false;
    }
    echo "</div>";

    // Check 5: Master Scheduler Test
    echo "<div class='section'>";
    echo "<h2>5. Master Scheduler Test</h2>";
    echo "<div class='code'>";
    echo "Recommended cPanel Cron Command:<br>";
    echo "<strong>*/5 * * * * /usr/local/bin/ea-php81 /home/nvdaxcom/public_html/core.galliumhash.com/automation/master-scheduler.php run</strong>";
    echo "</div>";
    
    // Test if we can execute the scheduler
    echo "<p>Testing master scheduler execution...</p>";
    $output = [];
    $returnCode = 0;
    exec('php master-scheduler.php test 2>&1', $output, $returnCode);
    
    if ($returnCode === 0) {
        echo "<p class='success'>✅ Master scheduler can be executed</p>";
        $checks['scheduler'] = true;
    } else {
        echo "<p class='warning'>⚠️ Master scheduler test result:</p>";
        echo "<div class='code'>" . implode('<br>', $output) . "</div>";
        $checks['scheduler'] = false;
    }
    echo "</div>";

    // Summary
    echo "<div class='section'>";
    echo "<h2>6. Setup Summary</h2>";
    $total_checks = count($checks);
    $passed_checks = array_sum($checks);
    
    if ($passed_checks == $total_checks) {
        echo "<p class='success'>🎉 All checks passed! Ready for deployment.</p>";
    } else {
        echo "<p class='warning'>⚠️ $passed_checks/$total_checks checks passed. Review issues above.</p>";
    }
    
    echo "<h3>Next Steps:</h3>";
    echo "<ol>";
    echo "<li>Set up the cron job in cPanel using the command above</li>";
    echo "<li>Wait 5 minutes for the first automated run</li>";
    echo "<li>Visit <a href='system-health.php'>system-health.php</a> to monitor status</li>";
    echo "<li>Check logs in the <code>logs/</code> directory</li>";
    echo "</ol>";
    echo "</div>";
    ?>

    <hr>
    <p><small>Generated: <?php echo date('Y-m-d H:i:s'); ?> UTC</small></p>
</body>
</html>